/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.listener.axis.rm;

import filenet.vw.api.VWException;
import filenet.vw.api.VWQueue;
import filenet.vw.api.VWQueueQuery;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWStepElement;
import filenet.vw.base.logging.Logger;
import filenet.ws.listener.axis.rm.WSRMCallbackData;
import filenet.ws.listener.axis.rm.WSRMSequenceInfo;
import filenet.ws.listener.utils.WSListenerProperties;
import org.apache.sandesha.storage.Callback;
import org.apache.sandesha.storage.CallbackData;

public class WSRMCallback
extends Callback {
    protected static Logger logger = Logger.getLogger("filenet.ws.listener.axis.rm");
    private static WSListenerProperties wsListenerProperties = null;
    private static WSRMCallback rmCallback = null;
    protected static final String m_className = "WSRMCallback";

    public static String _get_FILE_DATE() {
        return "$Date:   16 Oct 2006 21:09:02  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   lnguyen  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.5  $";
    }

    public static synchronized WSRMCallback getCallbackInstance() {
        if (rmCallback == null) {
            rmCallback = new WSRMCallback();
        }
        return rmCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void onIncomingMessage(CallbackData cbData) {
        String m_method = "onIncomingMessage";
        logger.entering(m_className, m_method);
        try {
            this.displayCallbackData((WSRMCallbackData)cbData);
            int msgType = cbData.getMessageType();
            String cpName = ((WSRMCallbackData)cbData).getCPName();
            String fullPath = ((WSRMCallbackData)cbData).getFullPath();
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, "Received msgType = " + msgType);
            }
            WSRMSequenceInfo seqInfo = WSRMSequenceInfo.getSequenceInfo((WSRMCallbackData)cbData);
            if (msgType == 5 || msgType == 4) {
                WSRMSequenceInfo relatesToSeqInfo;
                String relatesToMsgId = seqInfo.getRelatesToMsgId();
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "relatesToMsgId = " + relatesToMsgId);
                }
                if (relatesToMsgId != null && (relatesToSeqInfo = WSRMSequenceInfo.getSequenceInfoByMsgId(relatesToMsgId)) != null) {
                    if (msgType == 4) {
                        relatesToSeqInfo.setWaitForResponse(false);
                        relatesToSeqInfo.setServicePerformed();
                    }
                    if (msgType == 5) {
                        String wobNum = relatesToSeqInfo.getwobNum();
                        if (wobNum == null) {
                            wobNum = seqInfo.getwobNum();
                        }
                        if (logger.isFinest()) {
                            logger.finest(m_className, m_method, "wobNum = " + wobNum);
                        }
                        if (wobNum != null) {
                            try {
                                if (wsListenerProperties == null) {
                                    wsListenerProperties = WSListenerProperties.instanceFromFileName(fullPath, cpName);
                                }
                                VWSession vwSession = wsListenerProperties.getVWSession(cpName);
                                Object[] wobnumArray = new Object[]{wobNum};
                                if (logger.isFinest()) {
                                    logger.finest(m_className, m_method, "Query WSRequest(0) for wob # " + wobNum);
                                }
                                VWQueue queue = vwSession.getQueue("WSRequest(0)");
                                VWQueueQuery query = queue.createQuery("F_WobNum", wobnumArray, wobnumArray, 97, null, null, 5);
                                int count = 0;
                                if (query != null) {
                                    VWStepElement stepElement;
                                    count = query.fetchCount();
                                    if (logger.isFinest()) {
                                        logger.finest(m_className, m_method, "Query count = " + count);
                                    }
                                    if (count > 0 && query.hasNext() && (stepElement = (VWStepElement)query.next()) != null) {
                                        if (logger.isFinest()) {
                                            logger.finest(m_className, m_method, "Dispatch it!!! wornum = " + wobNum);
                                        }
                                        stepElement.doLock(true);
                                        stepElement.doDispatch();
                                    }
                                }
                            }
                            catch (VWException ex) {
                                logger.throwing(m_className, m_method, ex);
                            }
                            catch (Exception ex) {
                                logger.throwing(m_className, m_method, ex);
                            }
                        }
                    }
                    relatesToSeqInfo.isObsolete();
                }
            }
            seqInfo.displaySeqInfo();
        }
        catch (Exception ex) {
            logger.throwing(m_className, m_method, ex);
        }
        finally {
            logger.exiting(m_className, m_method);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void onOutgoingMessage(CallbackData cbData) {
        String method = "onOutgoingMessage";
        logger.entering(m_className, method);
        try {
            this.displayCallbackData((WSRMCallbackData)cbData);
            int msgType = cbData.getMessageType();
            if (logger.isFinest()) {
                logger.finest(m_className, method, "Sent msgType = " + msgType);
            }
            WSRMSequenceInfo seqInfo = WSRMSequenceInfo.getSequenceInfo((WSRMCallbackData)cbData);
            seqInfo.displaySeqInfo();
        }
        catch (Exception ex) {
            logger.throwing(m_className, method, ex);
        }
        finally {
            logger.exiting(m_className, method);
        }
    }

    public synchronized void onError(Exception exp) {
        String message = "Error Occured During the Interop Test";
        if (exp.getMessage() != null) {
            message = exp.getMessage();
        }
    }

    private void displayCallbackData(WSRMCallbackData cbData) {
        String method = "displayCallbackData";
        int type = cbData.getMessageType();
        String msgType = null;
        switch (type) {
            case 1: {
                msgType = "Create Sequence";
                break;
            }
            case 2: {
                msgType = "Create Sequence Response";
                break;
            }
            case 6: {
                msgType = "Terminate Sequence";
                break;
            }
            case 5: {
                msgType = "Sequence Acknowledgement";
                break;
            }
            case 3: {
                msgType = "Service Request";
                break;
            }
            case 4: {
                msgType = "Service Response";
            }
        }
        String EOL = "\n";
        StringBuffer info = new StringBuffer(EOL);
        info = info.append("  msgType = ").append(msgType).append(EOL);
        info = info.append("    Message type : ").append(cbData.getMessageType()).append(EOL);
        info = cbData.getIncoming() ? info.append("    Incoming") : info.append("    Outgoing");
        info.append(EOL);
        info = info.append("    Message Id : ").append(cbData.getMessageId()).append(EOL);
        info = info.append("    Sequence Id : ").append(cbData.getSequenceId()).append(EOL);
        info = info.append("    Related Message Id : ").append(cbData.getRelatesToMsgId()).append(EOL);
        info = info.append("    Action : ").append(cbData.getAction()).append(EOL);
        info = info.append("    rmAction : ").append(cbData.getRMAction()).append(EOL);
        info = info.append("    cpName : ").append(cbData.getCPName()).append(EOL);
        info = info.append("    fullPath : ").append(cbData.getFullPath()).append(EOL);
        if (logger.isFinest()) {
            logger.finest(m_className, method, info.toString());
        }
    }
}

